/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.photonabsorption.model;

import java.awt.geom.Point2D;
import java.util.Observable;

public class Photon
extends Observable {
    private final double wavelength;
    private final Point2D location = new Point2D.Double();
    private double vx;
    private double vy;

    public Photon(double d) {
        this.wavelength = d;
    }

    public void setVelocity(double d, double d2) {
        this.vx = d;
        this.vy = d2;
    }

    public double getWavelength() {
        return this.wavelength;
    }

    public Point2D getLocation() {
        return this.location;
    }

    public void setLocation(double d, double d2) {
        this.location.setLocation(d, d2);
        this.setChanged();
        this.notifyObservers();
    }

    public void stepInTime(double d) {
        this.setLocation(this.location.getX() + this.vx * d, this.location.getY() + this.vy * d);
    }
}

