/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.photonabsorption.model.molecules;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.photonabsorption.model.Molecule;
import edu.colorado.phet.common.photonabsorption.model.PhotonAbsorptionStrategy;
import edu.colorado.phet.common.photonabsorption.model.atoms.AtomicBond;
import edu.colorado.phet.common.photonabsorption.model.atoms.CarbonAtom;
import edu.colorado.phet.common.photonabsorption.model.atoms.OxygenAtom;
import java.awt.geom.Point2D;

public class CO2
extends Molecule {
    private static final double OXYGEN_MAX_DEFLECTION = new CarbonAtom().getMass() * 40.0 / (2.0 * new OxygenAtom().getMass());
    private final CarbonAtom carbonAtom = new CarbonAtom();
    private final OxygenAtom oxygenAtom1 = new OxygenAtom();
    private final OxygenAtom oxygenAtom2 = new OxygenAtom();
    private final AtomicBond carbonOxygenBond1 = new AtomicBond(this.carbonAtom, this.oxygenAtom1, 2);
    private final AtomicBond carbonOxygenBond2 = new AtomicBond(this.carbonAtom, this.oxygenAtom2, 2);

    public CO2(Point2D point2D) {
        this.addAtom(this.carbonAtom);
        this.addAtom(this.oxygenAtom1);
        this.addAtom(this.oxygenAtom2);
        this.addAtomicBond(this.carbonOxygenBond1);
        this.addAtomicBond(this.carbonOxygenBond2);
        this.setPhotonAbsorptionStrategy(8.5E-7, new PhotonAbsorptionStrategy.VibrationStrategy(this));
        this.initializeAtomOffsets();
        this.setCenterOfGravityPos(point2D);
    }

    public CO2() {
        this(new Point2D.Double(0.0, 0.0));
    }

    public void setVibration(double d) {
        super.setVibration(d);
        double d2 = Math.sin(d);
        this.addInitialAtomCogOffset(this.carbonAtom, new Vector2D(0.0, d2 * 40.0));
        this.addInitialAtomCogOffset(this.oxygenAtom1, new Vector2D(170.0, -d2 * OXYGEN_MAX_DEFLECTION));
        this.addInitialAtomCogOffset(this.oxygenAtom2, new Vector2D(-170.0, -d2 * OXYGEN_MAX_DEFLECTION));
        this.updateAtomPositions();
    }

    protected void initializeAtomOffsets() {
        this.addInitialAtomCogOffset(this.carbonAtom, new Vector2D(0.0, 0.0));
        this.addInitialAtomCogOffset(this.oxygenAtom1, new Vector2D(170.0, 0.0));
        this.addInitialAtomCogOffset(this.oxygenAtom2, new Vector2D(-170.0, 0.0));
        this.updateAtomPositions();
    }
}

