/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.common.graphics;

import edu.colorado.phet.greenhouse.GreenhouseResources;
import edu.colorado.phet.greenhouse.common.graphics.Graphic;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public class ImageGraphic
implements Graphic,
ImageObserver {
    private BufferedImage image;
    private Point2D.Double location = new Point2D.Double();
    private AffineTransform imageTx;
    private AffineTransform orgTx;

    public ImageGraphic(String string, Point2D.Double double_) {
        this(GreenhouseResources.getImage(string), double_);
    }

    public ImageGraphic(BufferedImage bufferedImage, Point2D.Double double_) {
        this.image = bufferedImage;
        this.location = double_;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return false;
    }

    public void paint(Graphics2D graphics2D) {
        this.orgTx = graphics2D.getTransform();
        this.imageTx = new AffineTransform();
        this.imageTx.translate(this.orgTx.getTranslateX() / this.orgTx.getScaleX(), this.orgTx.getTranslateY() / this.orgTx.getScaleY());
        if (graphics2D.getTransform().getDeterminant() == 0.0) {
            return;
        }
        try {
            this.imageTx.concatenate(graphics2D.getTransform().createInverse());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new RuntimeException(noninvertibleTransformException);
        }
        this.imageTx.translate(0.0, -this.image.getHeight());
        this.imageTx.translate(this.location.getX() * this.orgTx.getScaleX(), this.location.getY() * this.orgTx.getScaleY());
        graphics2D.drawImage(this.image, this.imageTx, this);
    }

    public AffineTransform getImageTx() {
        return this.imageTx;
    }

    public BufferedImage getBufferedImage() {
        return this.image;
    }
}

