/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.view;

import edu.colorado.phet.greenhouse.GreenhouseConfig;
import edu.colorado.phet.greenhouse.GreenhouseResources;
import edu.colorado.phet.greenhouse.common.graphics.CompositeGraphic;
import edu.colorado.phet.greenhouse.common.graphics.ImageGraphic;
import edu.colorado.phet.greenhouse.model.Atmosphere;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ImagingOpException;
import java.util.Observable;
import java.util.Observer;

public class AtmosphereGraphic
extends CompositeGraphic
implements Observer {
    private double Y_OFFSET = -1.0;
    private Atmosphere atmosphere;
    private float greenhouseAlpha;
    private double maxAlpha = 0.4;
    private ImageGraphic atmosphereImageGraphic;
    private boolean visible;

    public AtmosphereGraphic(Atmosphere atmosphere, final Rectangle2D rectangle2D, Component component) {
        this.atmosphere = atmosphere;
        atmosphere.addObserver(this);
        BufferedImage bufferedImage = GreenhouseResources.getImage("pollution.gif");
        this.atmosphereImageGraphic = new ImageGraphic(bufferedImage, new Point2D.Double(-rectangle2D.getWidth() / 2.0, this.Y_OFFSET));
        this.addGraphic(this.atmosphereImageGraphic, 1.0);
        this.update();
        component.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Component component = componentEvent.getComponent();
                Rectangle rectangle = component.getBounds();
                if (AtmosphereGraphic.this.atmosphereImageGraphic != null) {
                    BufferedImage bufferedImage = AtmosphereGraphic.this.atmosphereImageGraphic.getBufferedImage();
                    if (((RectangularShape)rectangle).getWidth() > 0.0 && ((RectangularShape)rectangle).getHeight() > 0.0 && bufferedImage.getWidth() > 0 && bufferedImage.getHeight() > 0) {
                        double d = ((RectangularShape)rectangle).getWidth() / (double)bufferedImage.getWidth();
                        double d2 = ((RectangularShape)rectangle).getHeight() / (double)bufferedImage.getHeight();
                        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d2);
                        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
                        try {
                            bufferedImage = affineTransformOp.filter(bufferedImage, null);
                            AtmosphereGraphic.this.removeGraphic(AtmosphereGraphic.this.atmosphereImageGraphic);
                            AtmosphereGraphic.this.atmosphereImageGraphic = new ImageGraphic(bufferedImage, new Point2D.Double(-rectangle2D.getWidth() / 2.0, AtmosphereGraphic.this.Y_OFFSET));
                            AtmosphereGraphic.this.addGraphic(AtmosphereGraphic.this.atmosphereImageGraphic, 1.0);
                        }
                        catch (ImagingOpException imagingOpException) {
                            System.out.println("Caught ioe=" + imagingOpException);
                            imagingOpException.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void paint(Graphics2D graphics2D) {
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.greenhouseAlpha));
        super.paint(graphics2D);
        graphics2D.setComposite(composite);
    }

    public void update(Observable observable, Object object) {
        this.update();
    }

    private void update() {
        this.greenhouseAlpha = this.computeGreenhouseAlpha();
    }

    private float computeGreenhouseAlpha() {
        if (this.visible) {
            return (float)(this.maxAlpha * this.atmosphere.getGreenhouseGasConcentration() / GreenhouseConfig.maxGreenhouseGasConcentration);
        }
        return 0.0f;
    }
}

