/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.view;

import edu.colorado.phet.greenhouse.GreenhouseConfig;
import edu.colorado.phet.greenhouse.GreenhouseResources;
import edu.colorado.phet.greenhouse.common.graphics.ApparatusPanel;
import edu.colorado.phet.greenhouse.common.graphics.Graphic;
import edu.colorado.phet.greenhouse.common.graphics.ImageGraphic;
import edu.colorado.phet.greenhouse.model.Earth;
import edu.colorado.phet.greenhouse.model.Photon;
import edu.colorado.phet.greenhouse.model.ReflectivityAssessor;
import edu.colorado.phet.greenhouse.view.DiskGraphic;
import edu.umd.cs.piccolo.util.PAffineTransform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;

public class EarthGraphic
implements Graphic,
ReflectivityAssessor {
    private final ApparatusPanel apparatusPanel;
    Earth earth;
    private final Rectangle2D.Double modelBounds;
    private static int numRedsToAve = 20;
    int[] redsToAve = new int[numRedsToAve];
    private GreenhouseBackgroundImageGraphic backdropGraphic;
    private final DiskGraphic disk;
    private final Color earthBaseColor = new Color(0, 180, 100);
    private boolean isIceAge;
    private BufferedImage currentBackdropImage;
    private final BufferedImage backgroundToday = GreenhouseResources.getImage("today-2.gif");
    private final BufferedImage background1750 = GreenhouseResources.getImage("1750-2.gif");
    private final BufferedImage backgroundIceAge = GreenhouseResources.getImage("ice-age-2.gif");

    public EarthGraphic(ApparatusPanel apparatusPanel, Earth earth, final Rectangle2D.Double double_) {
        this.apparatusPanel = apparatusPanel;
        this.earth = earth;
        this.modelBounds = double_;
        this.disk = new DiskGraphic(earth, this.earthBaseColor);
        apparatusPanel.addGraphic(this.disk, GreenhouseConfig.EARTH_BASE_LAYER);
        Point2D.Double double_2 = new Point2D.Double(earth.getLocation().getX(), earth.getLocation().getY());
        double_2.setLocation(double_2.getX() - earth.getRadius() / 2.0, double_2.getY() + earth.getRadius() / 2.0);
        apparatusPanel.addGraphic(this, GreenhouseConfig.EARTH_BASE_LAYER + 1.0);
        apparatusPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Component component = componentEvent.getComponent();
                Rectangle rectangle = component.getBounds();
                if (((RectangularShape)rectangle).getWidth() > 0.0 && ((RectangularShape)rectangle).getHeight() > 0.0 && EarthGraphic.this.currentBackdropImage != null) {
                    EarthGraphic.this.setBackDropImage(EarthGraphic.this.currentBackdropImage, new Point2D.Double(-double_.getWidth() / 2.0, -1.0));
                }
            }
        });
    }

    public void paint(Graphics2D graphics2D) {
        int n = Math.max(0, Math.min((int)(this.earth.getTemperature() - 251.0), 255));
        int n2 = 0;
        for (int i = numRedsToAve - 1; i > 0; --i) {
            this.redsToAve[i] = this.redsToAve[i - 1];
            n2 += this.redsToAve[i];
        }
        this.redsToAve[0] = n;
        n2 += n;
        n = Math.min(2 * n2 / numRedsToAve, 255);
        graphics2D.setColor(Color.gray);
    }

    public void setNoBackdrop() {
        this.isIceAge = false;
        this.setBackDrop(null, null);
        this.disk.setPaint(new Color(51, 160, 44));
    }

    public void setVirginEarth() {
        this.isIceAge = false;
        this.setBackDropImage(this.backgroundToday, new Point2D.Double(-this.modelBounds.getWidth() / 2.0, -1.0));
        this.disk.setPaint(new Color(51, 160, 44, 0));
    }

    public void setToday() {
        this.isIceAge = false;
        this.setBackDropImage(this.backgroundToday, new Point2D.Double(-this.modelBounds.getWidth() / 2.0, -1.0));
        this.disk.setPaint(new Color(22, 174, 73, 0));
    }

    public void set1750() {
        this.isIceAge = false;
        this.setBackDropImage(this.background1750, new Point2D.Double(-this.modelBounds.getWidth() / 2.0, -1.0));
        this.disk.setPaint(new Color(25, 174, 73, 0));
    }

    public void setIceAge() {
        this.isIceAge = true;
        this.setBackDropImage(this.backgroundIceAge, new Point2D.Double(-this.modelBounds.getWidth() / 2.0, -1.0));
        this.disk.setPaint(new Color(149, 134, 78));
    }

    private void setBackDrop(BufferedImage bufferedImage, Point2D.Double double_) {
        this.currentBackdropImage = bufferedImage;
        if (this.backdropGraphic != null) {
            this.apparatusPanel.removeGraphic(this.backdropGraphic);
        }
        if (bufferedImage != null) {
            this.backdropGraphic = new GreenhouseBackgroundImageGraphic(bufferedImage, double_, this.apparatusPanel);
            this.apparatusPanel.addGraphic(this.backdropGraphic, GreenhouseConfig.EARTH_BACKDROP_LAYER);
        }
    }

    private void setBackDropImage(BufferedImage bufferedImage, Point2D.Double double_) {
        this.currentBackdropImage = bufferedImage;
        if (this.backdropGraphic != null) {
            this.apparatusPanel.removeGraphic(this.backdropGraphic);
        }
        this.backdropGraphic = new GreenhouseBackgroundImageGraphic(this.currentBackdropImage, double_, this.apparatusPanel);
        this.apparatusPanel.addGraphic(this.backdropGraphic, GreenhouseConfig.EARTH_BACKDROP_LAYER);
    }

    public double getReflectivity(Photon photon) {
        Point2D point2D;
        Color color;
        double d = 0.0;
        if (this.isIceAge && this.backdropGraphic != null && photon.getVelocity().getY() < 0.0 && photon.getWavelength() == 4.0E-7 && (color = this.backdropGraphic.getColor((point2D = this.apparatusPanel.modelToView(photon.getLocation())).getX(), point2D.getY())).getRed() == 255 && color.getGreen() == 255 && color.getBlue() == 255) {
            d = 0.6;
        }
        return d;
    }

    static class GreenhouseBackgroundImageGraphic
    extends ImageGraphic {
        private final BufferedImage image;
        private final ApparatusPanel apparatusPanel;

        public GreenhouseBackgroundImageGraphic(BufferedImage bufferedImage, Point2D.Double double_, ApparatusPanel apparatusPanel) {
            super(bufferedImage, double_);
            this.image = bufferedImage;
            this.apparatusPanel = apparatusPanel;
        }

        public void paint(Graphics2D graphics2D) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.setTransform(new AffineTransform());
            graphics2D.drawRenderedImage(this.image, this.getTransform());
            graphics2D.setTransform(affineTransform);
        }

        private PAffineTransform getTransform() {
            PAffineTransform pAffineTransform = new PAffineTransform();
            double d = (double)this.apparatusPanel.getWidth() / (double)this.image.getWidth();
            double d2 = (double)this.apparatusPanel.getHeight() / (double)this.image.getHeight();
            pAffineTransform.translate(0.0, (double)this.apparatusPanel.getHeight() - (double)this.image.getHeight() * d2);
            pAffineTransform.scale(d, d2);
            return pAffineTransform;
        }

        public Color getColor(double d, double d2) {
            try {
                Point2D point2D = this.getTransform().createInverse().transform(new Point2D.Double(d, d2), null);
                int n = (int)point2D.getX();
                int n2 = (int)point2D.getY();
                if (n >= 0 && n2 >= 0 && n < this.image.getWidth() && n2 < this.image.getHeight()) {
                    int n3 = this.image.getRGB(n, n2);
                    int n4 = (n3 & 0xFF0000) >> 16;
                    int n5 = (n3 & 0xFF00) >> 8;
                    int n6 = n3 & 0xFF;
                    return new Color(n4, n5, n6);
                }
                return Color.black;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return Color.black;
            }
        }
    }
}

